/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Test;

public class RouteAwareProcessorTest
extends ContextTestSupport {
    private final MyProcessor processor = new MyProcessor();

    @Test
    public void testRouteIdAware() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello route foo from processor myProcessor"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").process((Processor)RouteAwareProcessorTest.this.processor)).id("myProcessor")).to("mock:result");
            }
        };
    }

    private static class MyProcessor
    extends ServiceSupport
    implements Processor,
    RouteIdAware,
    IdAware {
        private String id;
        private String routeId;

        private MyProcessor() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getRouteId() {
            return this.routeId;
        }

        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)("Hello route " + this.routeId + " from processor " + this.id));
        }
    }
}

