/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteAutoStartupTest
extends ContextTestSupport {
    @Test
    public void testRouteAutoStartedUsingBoolean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").autoStartup(true).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteNotAutoStartedUsingBoolean() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").id("route1")).autoStartup(false).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"route shouldn't be started yet");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        this.context.getRouteController().startRoute("route1");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteAutoStartedUsingString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").autoStartup("true").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteNotAutoStartedUsingString() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").id("route1")).autoStartup("false").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"route shouldn't be started yet");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        this.context.getRouteController().startRoute("route1");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteAutoStartedUsingProperties() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                RouteAutoStartupTest.this.context.getPropertiesComponent().setLocation("classpath:org/apache/camel/processor/routeAutoStartupTest.properties");
                this.from("direct:start").autoStartup("{{autoStartupProp}}").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteNotAutoStartedUsingProperties() throws Exception {
        ((DirectComponent)this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                RouteAutoStartupTest.this.context.getPropertiesComponent().setLocation("classpath:org/apache/camel/processor/routeAutoStartupTest.properties");
                ((RouteDefinition)this.from("direct:start").id("route1")).autoStartup("{{noAutoStartupProp}}").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"route shouldn't be started yet");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        this.context.getRouteController().startRoute("route1");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

