/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoundRobinLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().roundRobin().to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        };
    }

    @Test
    public void testRoundRobin() throws Exception {
        String body = "<one/>";
        this.x.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.y, this.z});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
        this.x.reset();
        body = "<two/>";
        this.y.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.z});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
        this.y.reset();
        body = "<three/>";
        this.z.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.y});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(Object headerValue, Object body) {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }
}

