/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RollbackTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(0);
        this.template.requestBody("direct:start", (Object)"ok");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollback() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(1);
        try {
            this.template.requestBody("direct:start", (Object)"bad");
            Assertions.fail((String)"Should have thrown a RollbackExchangeException");
        }
        catch (RuntimeCamelException e) {
            boolean b = e.getCause() instanceof RollbackExchangeException;
            Assertions.assertTrue((boolean)b);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollbackWithExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(1);
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"bad");
            }
        });
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)out.getException());
        RollbackTest.assertIsInstanceOf(RollbackExchangeException.class, out.getException());
        Assertions.assertTrue((boolean)out.isRollbackOnly(), (String)"Should be marked as rollback");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isNotEqualTo((Object)"ok")).to("mock:rollback")).rollback("That do not work")).otherwise().to("mock:result")).end();
            }
        };
    }
}

