/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RollbackDoTryCatchTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(0);
        this.getMockEndpoint("mock:doCatch").expectedMessageCount(0);
        this.template.requestBody("direct:start", (Object)"ok");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollback() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(1);
        this.getMockEndpoint("mock:doCatch").expectedMessageCount(1);
        try {
            this.template.requestBody("direct:start", (Object)"bad");
            Assertions.fail((String)"Should have thrown a RollbackExchangeException");
        }
        catch (RuntimeCamelException e) {
            boolean b = e.getCause() instanceof RollbackExchangeException;
            Assertions.assertTrue((boolean)b);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollbackWithExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(1);
        this.getMockEndpoint("mock:doCatch").expectedMessageCount(1);
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"bad");
            }
        });
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)out.getException());
        RollbackDoTryCatchTest.assertIsInstanceOf(RollbackExchangeException.class, out.getException());
        Assertions.assertTrue((boolean)out.isRollbackOnly(), (String)"Should be marked as rollback");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("mock:doTry")).to("direct:rollback")).doCatch(Throwable.class).log("doCatch")).to("mock:doCatch")).end().to("mock:result");
                ((ChoiceDefinition)this.from("direct:rollback").choice().when(this.body().isNotEqualTo((Object)"ok")).to("mock:rollback")).rollback("That do not work");
            }
        };
    }
}

