/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RollbackDefaultErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.requestBody("direct:start", (Object)"ok");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollback() {
        try {
            this.template.requestBody("direct:start", (Object)"bad");
            Assertions.fail((String)"Should have thrown a RollbackExchangeException");
        }
        catch (RuntimeCamelException e) {
            boolean b = e.getCause() instanceof RollbackExchangeException;
            Assertions.assertTrue((boolean)b);
        }
    }

    @Test
    public void testRollbackWithExchange() {
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"bad");
            }
        });
        Assertions.assertNotNull((Object)out.getException());
        RollbackDefaultErrorHandlerTest.assertIsInstanceOf(RollbackExchangeException.class, out.getException());
        Assertions.assertTrue((boolean)out.isRollbackOnly(), (String)"Should be marked as rollback");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isNotEqualTo((Object)"ok")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertFalse((boolean)exchange.isRollbackOnly(), (String)"Rollback flag should have been cleared on redelivery");
                    }
                })).to("mock:rollback")).rollback("That do not work")).otherwise().to("mock:result")).end();
            }
        };
    }
}

