/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.DefaultChannel;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ResequencerTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Test
    public void testSendMessagesInWrongOrderButReceiveThemInCorrectOrder() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Guillaume", "Hiram", "James", "Rob"});
        this.sendBodies("direct:start", "Rob", "Hiram", "Guillaume", "James");
        this.resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testRestartRoute() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Guillaume", "Hiram", "James", "Rob"});
        this.sendBodies("direct:start", "Rob", "Hiram", "Guillaume", "James");
        this.resultEndpoint.assertIsSatisfied();
        this.context.getRouteController().stopRoute("myRoute");
        Thread.sleep(5L);
        this.resultEndpoint.reset();
        this.context.getRouteController().startRoute("myRoute");
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Donald", "Goofy", "Jack"});
        this.sendBodies("direct:start", "Jack", "Donald", "Goofy");
        this.resultEndpoint.assertIsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected boolean useJmx() {
        return this.getName().equals("testBatchResequencerTypeWithJmx");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ResequenceDefinition)this.from("direct:start").routeId("myRoute").resequence().body()).timeout(50L).to("mock:result");
            }
        };
    }

    @Test
    public void testBatchResequencerTypeWithJmx() throws Exception {
        this.testBatchResequencerTypeWithoutJmx();
    }

    @Test
    public void testBatchResequencerTypeWithoutJmx() throws Exception {
        List<Route> list = ResequencerTest.getRouteList(this.createRouteBuilder());
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Number of routes created: " + String.valueOf(list)));
        Route route = list.get(0);
        DefaultRoute consumerRoute = ResequencerTest.assertIsInstanceOf(DefaultRoute.class, route);
        DefaultChannel channel = ResequencerTest.assertIsInstanceOf(DefaultChannel.class, ResequencerTest.unwrapChannel(consumerRoute.getProcessor()));
        ResequencerTest.assertIsInstanceOf(DefaultErrorHandler.class, channel.getErrorHandler());
        ResequencerTest.assertIsInstanceOf(Resequencer.class, channel.getNextProcessor());
    }
}

