/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResequenceStreamNotIgnoreInvalidExchangesTest
extends ContextTestSupport {
    @Test
    public void testBadFirstMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"A"), (String)"Should have thrown an exception");
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBadSecondMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"A"), (String)"Should have thrown an exception");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBadThirdMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"A"), (String)"Should have thrown an exception");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBadForthMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"A"), (String)"Should have thrown an exception");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)this.header("seqno")).stream().timeout(150L).deliveryAttemptInterval(10L).to("mock:result");
            }
        };
    }
}

