/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class ResequenceStreamIgnoreInvalidExchangesTest
extends ContextTestSupport {
    @Test
    public void testBadFirstMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBadSecondMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBadThirdMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBadForthMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"B", "C", "D"});
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "seqno", (Object)4);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "seqno", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "seqno", (Object)2);
        this.template.sendBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)this.header("seqno")).stream().timeout(50L).deliveryAttemptInterval(10L).ignoreInvalidExchanges().to("mock:result");
            }
        };
    }
}

