/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemovePropertyTest
extends ContextTestSupport {
    private MockEndpoint end;
    private MockEndpoint mid;
    private final String propertyName = "foo";
    private final String expectedPropertyValue = "bar";

    @Test
    public void testSetExchangePropertyMidRouteThenRemove() throws Exception {
        this.mid.expectedMessageCount(1);
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<blah/>");
        this.assertMockEndpointsSatisfied();
        List midExchanges = this.mid.getExchanges();
        Exchange midExchange = (Exchange)midExchanges.get(0);
        String actualPropertyValue = (String)midExchange.getProperty("foo", String.class);
        Assertions.assertEquals((Object)"bar", (Object)actualPropertyValue);
        List endExchanges = this.end.getExchanges();
        Exchange endExchange = (Exchange)endExchanges.get(0);
        Assertions.assertNull((Object)endExchange.getProperty("foo", String.class));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
        this.mid = this.getMockEndpoint("mock:mid");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)this.from("direct:start").setProperty("foo").constant((Object)"bar")).to("mock:mid")).removeProperty("foo")).to("mock:end");
            }
        };
    }
}

