/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemovePropertiesWithExclusionTest
extends ContextTestSupport {
    private MockEndpoint end;
    private MockEndpoint mid;
    private final String propertyName = "foo";
    private final String expectedPropertyValue = "bar";
    private final String propertyName1 = "fee";
    private final String expectedPropertyValue1 = "bar1";
    private final String propertyName2 = "fiu";
    private final String expectedPropertyValue2 = "bar2";
    private final String pattern = "f*";
    private final String exclusion = "fiu";

    @Test
    public void testSetExchangePropertiesMidRouteThenRemoveWithPatternAndExclusion() throws Exception {
        this.mid.expectedMessageCount(1);
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"message");
        this.assertMockEndpointsSatisfied();
        List midExchanges = this.mid.getExchanges();
        Exchange midExchange = (Exchange)midExchanges.get(0);
        String actualPropertyValue = (String)midExchange.getProperty("foo", String.class);
        String actualPropertyValue1 = (String)midExchange.getProperty("fee", String.class);
        String actualPropertyValue2 = (String)midExchange.getProperty("fiu", String.class);
        Assertions.assertEquals((Object)"bar", (Object)actualPropertyValue);
        Assertions.assertEquals((Object)"bar1", (Object)actualPropertyValue1);
        Assertions.assertEquals((Object)"bar2", (Object)actualPropertyValue2);
        List endExchanges = this.end.getExchanges();
        Exchange endExchange = (Exchange)endExchanges.get(0);
        Assertions.assertNull((Object)endExchange.getProperty("foo", String.class));
        Assertions.assertNull((Object)endExchange.getProperty("fee", String.class));
        Assertions.assertEquals((Object)"bar2", (Object)endExchange.getProperty("fiu", String.class));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
        this.mid = this.getMockEndpoint("mock:mid");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:start").setProperty("foo").constant((Object)"bar")).setProperty("fee").constant((Object)"bar1")).setProperty("fiu").constant((Object)"bar2")).to("mock:mid")).removeProperties("f*", new String[]{"fiu"})).to("mock:end");
            }
        };
    }
}

