/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveHeadersExcludeTest
extends ContextTestSupport {
    @Test
    public void testRemoveHeadersWildcard() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("duck", (Object)"Donald");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("dudeCool", "cool");
        headers.put("dudeWicket", "wicket");
        headers.put("duck", "Donald");
        headers.put("foo", "bar");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders().size());
    }

    @Test
    public void testRemoveHeadersRegEx() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("duck", (Object)"Donald");
        mock.expectedHeaderReceived("BeerHeineken", (Object)"Good");
        mock.expectedHeaderReceived("BeerTuborg", (Object)"Also Great");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("dudeCool", "cool");
        headers.put("dudeWicket", "wicket");
        headers.put("duck", "Donald");
        headers.put("BeerCarlsberg", "Great");
        headers.put("BeerTuborg", "Also Great");
        headers.put("BeerHeineken", "Good");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").removeHeaders("dude*")).removeHeaders("Beer*", new String[]{".*Heineken.*", ".*Tuborg.*"})).removeHeaders("foo")).to("mock:end");
            }
        };
    }
}

