/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveHeadersAllTest
extends ContextTestSupport {
    @Test
    public void testRemoveHeadersAll() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("dudeCool", "cool");
        headers.put("DudeWicket", "wicket");
        headers.put("DUDEbig", "upper");
        headers.put("duck", "Donald");
        headers.put("foo", "bar");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders().size());
    }

    @Test
    public void testRemoveHeadersAllExclude() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("duck", (Object)"Donald");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("dudeCool", "cool");
        headers.put("DudeWicket", "wicket");
        headers.put("DUDEbig", "upper");
        headers.put("duck", "Donald");
        headers.put("foo", "bar");
        this.template.sendBodyAndHeaders("direct:startWithExclude", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders().size());
    }

    @Test
    public void testRemoveHeadersAllExcludeNoMatch() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("dudeCool", "cool");
        headers.put("DudeWicket", "wicket");
        headers.put("DUDEbig", "upper");
        headers.put("duck", "Donald");
        headers.put("foo", "bar");
        this.template.sendBodyAndHeaders("direct:startWithExcludeNoMatch", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").removeHeaders("*")).to("mock:end");
                ((RouteDefinition)this.from("direct:startWithExclude").removeHeaders("*", new String[]{"duck"})).to("mock:end");
                ((RouteDefinition)this.from("direct:startWithExcludeNoMatch").removeHeaders("*", new String[]{"dog"})).to("mock:end");
            }
        };
    }
}

