/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RegExRouteTest
extends ContextTestSupport {
    final String orignalBody = "Foo and another Foo";
    final String expectedBody = "Bar and another Bar";

    @Test
    public void testSendingMessage() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Bar and another Bar"});
        this.template.sendBody("direct:start", (Object)"Foo and another Foo");
        result.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.regexReplaceAll((Expression)this.body(), "Foo", "Bar"))).to("mock:result");
            }
        };
    }
}

