/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryErrorHandlerNonBlockedRedeliveryHeaderTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryErrorHandlerNonBlockedRedeliveryHeaderTest.class);
    private static final LongAdder attempt = new LongAdder();

    @Test
    public void testRedelivery() throws Exception {
        MockEndpoint before = this.getMockEndpoint("mock:result");
        before.expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello Camel", "Hello World"});
        this.template.sendBodyAndHeader("seda:start", (Object)"World", "CamelRedeliveryDelay", (Object)500);
        this.template.sendBodyAndHeader("seda:start", (Object)"Camel", "CamelRedeliveryDelay", (Object)500);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(5).redeliveryDelay(10000L).asyncDelayedRedelivery());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:before")).to("mock:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        LOG.info("Processing at attempt {} {}", (Object)attempt, (Object)exchange);
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body.contains("World")) {
                            attempt.increment();
                            if (attempt.intValue() <= 2) {
                                LOG.info("Processing failed will thrown an exception");
                                throw new IllegalArgumentException("Damn");
                            }
                        }
                        exchange.getIn().setBody((Object)("Hello " + body));
                        LOG.info("Processing at attempt {} complete {}", (Object)attempt, (Object)exchange);
                    }
                })).to("log:after")).to("mock:result");
            }
        };
    }
}

