/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RedeliveryErrorHandlerLogHandledTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRedeliveryErrorHandlerOnExceptionLogHandledDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).redeliveryDelay(0L).handled(true).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRedeliveryErrorHandlerOnExceptionLogHandled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).redeliveryDelay(0L).logHandled(true).handled(true).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRedeliveryErrorHandlerOnExceptionLogRetryAttempted() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).redeliveryDelay(0L).logHandled(true).logRetryAttempted(true).handled(true).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRedeliveryErrorHandlerDoNotLogExhausted() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().logExhausted(false));
                this.from("direct:bar").throwException((Exception)new CamelException("Camel rocks"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:bar", (Object)"Hello World");
            Assertions.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelException cause = RedeliveryErrorHandlerLogHandledTest.assertIsInstanceOf(CamelException.class, e.getCause());
            Assertions.assertEquals((Object)"Camel rocks", (Object)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRedeliveryErrorHandlerLogExhaustedDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler());
                this.from("direct:bar").throwException((Exception)new CamelException("Camel rocks"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:bar", (Object)"Hello World");
            Assertions.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelException cause = RedeliveryErrorHandlerLogHandledTest.assertIsInstanceOf(CamelException.class, e.getCause());
            Assertions.assertEquals((Object)"Camel rocks", (Object)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRedeliveryErrorHandlerAllOptions() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().redeliveryDelay(0L).maximumRedeliveries(3).logExhausted(true).logHandled(true).logRetryStackTrace(true).logStackTrace(true).retryAttemptedLogLevel(LoggingLevel.WARN).retriesExhaustedLogLevel(LoggingLevel.ERROR));
                this.from("direct:bar").throwException((Exception)new CamelException("Camel rocks"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:bar", (Object)"Hello World");
            Assertions.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelException cause = RedeliveryErrorHandlerLogHandledTest.assertIsInstanceOf(CamelException.class, e.getCause());
            Assertions.assertEquals((Object)"Camel rocks", (Object)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRedeliveryErrorHandlerOnExceptionAllOptions() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).redeliveryDelay(0L).maximumRedeliveries(3).logHandled(true).logRetryAttempted(true).logRetryStackTrace(true).logExhausted(true).logStackTrace(true).handled(true).retryAttemptedLogLevel(LoggingLevel.WARN).retriesExhaustedLogLevel(LoggingLevel.ERROR).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

