/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RedeliveryErrorHandlerBreakoutDuringShutdownTest
extends ContextTestSupport {
    @Test
    public void testRedelivery() throws Exception {
        this.getMockEndpoint("mock:before").expectedMessageCount(1);
        this.getMockEndpoint("mock:after").expectedMessageCount(0);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        StopWatch watch = new StopWatch();
        this.context.getShutdownStrategy().setTimeout(1L);
        this.context.stop();
        Assertions.assertTrue((watch.taken() < 5000L ? 1 : 0) != 0, (String)"Should take less than 5 seconds, was {}");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(-1).redeliveryDelay(1000L));
                ((RouteDefinition)((RouteDefinition)this.from("seda:start").to("mock:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced");
                    }
                })).to("mock:after");
            }
        };
    }
}

