/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class RedeliveryDeadLetterErrorHandlerNoRedeliveryOnShutdownTest
extends ContextTestSupport {
    private final AtomicInteger counter = new AtomicInteger();

    @Test
    public void testRedeliveryErrorHandlerNoRedeliveryOnShutdown() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:deadLetter").expectedMessageCount(1);
        this.getMockEndpoint("mock:deadLetter").setResultWaitTime(25000L);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.getMockEndpoint("mock:foo").assertIsSatisfied();
        StopWatch watch = new StopWatch();
        Thread.sleep(500L);
        this.log.info("==== stopping route foo ====");
        this.context.getRouteController().stopRoute("foo");
        long taken = watch.taken();
        this.getMockEndpoint("mock:deadLetter").assertIsSatisfied();
        this.log.info("OnRedelivery processor counter {}", (Object)this.counter.get());
        Assertions.assertTrue((taken < 5000L ? 1 : 0) != 0, (String)("Should stop route faster, was " + taken));
        Assertions.assertTrue((this.counter.get() >= 20 && this.counter.get() < 100 ? 1 : 0) != 0, (String)("Redelivery counter should be >= 20 and < 100, was: " + this.counter.get()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:deadLetter").allowRedeliveryWhileStopping(false).onRedelivery((Processor)new MyRedeliverProcessor()).maximumRedeliveries(200).redeliveryDelay(10L).retryAttemptedLogLevel(LoggingLevel.INFO));
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    private final class MyRedeliverProcessor
    implements Processor {
        private MyRedeliverProcessor() {
        }

        public void process(Exchange exchange) {
            RedeliveryDeadLetterErrorHandlerNoRedeliveryOnShutdownTest.this.counter.incrementAndGet();
        }
    }
}

