/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test creates a larger thread pool, which may be too much on slower hosts")
public class RecipientListWithSimpleExpressionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.simple("mock:${in.header.queue}"));
            }
        });
        this.context.start();
        this.template.start();
        for (int i = 0; i < 10; ++i) {
            this.getMockEndpoint("mock:" + i).expectedMessageCount(50);
        }
        ExecutorService executors = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 50; ++i) {
            executors.execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            RecipientListWithSimpleExpressionTest.this.template.sendBodyAndHeader("direct:start", (Object)("Hello " + i), "queue", (Object)i);
                            Thread.sleep(5L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        this.assertMockEndpointsSatisfied();
        executors.shutdownNow();
    }
}

