/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class RecipientListWithDelimiterTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("myHeader"), "#");
            }
        });
        this.context.start();
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListWithDelimiterDisabled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("myHeader"), "false");
            }
        });
        this.context.start();
        MockEndpoint xyz = this.getMockEndpoint("mock:falseDelimiterTest");
        xyz.expectedBodiesReceived(new Object[]{"answer"});
        this.template.sendBodyAndHeader("direct:a", (Object)"answer", "myHeader", (Object)"mock:falseDelimiterTest");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListWithTokenizer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("myHeader").tokenize("#"));
            }
        });
        this.context.start();
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)"answer", "myHeader", (Object)"mock:x#mock:y#mock:z");
    }
}

