/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

public class RecipientListThrowExceptionSubRouteTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:start").onException(Exception.class).to("mock:error")).end().recipientList((Expression)this.method(Router.class));
            }
        });
        this.context.start();
        MockEndpoint endpoint = this.getMockEndpoint("mock:error");
        endpoint.expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World!");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListChild() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:start").onException(Exception.class).to("mock:error")).end().to("direct:child");
                this.from("direct:child").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).recipientList((Expression)this.method(Router.class));
            }
        });
        this.context.start();
        MockEndpoint endpoint = this.getMockEndpoint("mock:error");
        endpoint.expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World!");
        this.assertMockEndpointsSatisfied();
    }

    public static class Router {
        public String findEndpoint() {
            throw new IllegalArgumentException("Damn");
        }
    }
}

