/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListStopOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testRecipientListStopOnException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RecipientListStopOnExceptionTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            RecipientListStopOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.header("foo")).stopOnException().to("mock:result");
                this.from("direct:a").to("mock:a");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).throwException((Exception)new IllegalArgumentException("Damn"));
                this.from("direct:c").to("mock:c");
            }
        };
    }
}

