/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListReturnValueTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    @Test
    public void testRecipientListWithRecipientList() throws Exception {
        this.doTestRecipientList("direct:recipientList");
    }

    @Test
    public void testRecipientListWithBeanRef() throws Exception {
        this.doTestRecipientList("direct:beanRef");
    }

    private void doTestRecipientList(String uri) throws InterruptedException {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedBodiesReceived(new Object[]{"Hello a"});
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedBodiesReceived(new Object[]{"Hello b"});
        String out = (String)this.template.requestBody(uri, (Object)("Hello " + uri), String.class);
        Assertions.assertEquals((Object)"Hello b", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:beanRef").bean((Object)"myBean", "route");
                this.from("direct:recipientList").recipientList().method("myBean", "recipientList");
                ((RouteDefinition)this.from("direct:a").transform((Expression)this.constant("Hello a"))).to("mock:a");
                ((RouteDefinition)this.from("direct:b").transform((Expression)this.constant("Hello b"))).to("mock:b");
            }
        };
    }

    public static class MyBean {
        @RecipientList
        public String[] route() {
            return new String[]{"direct:a", "direct:b"};
        }

        public String[] recipientList() {
            return new String[]{"direct:a", "direct:b"};
        }
    }
}

