/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.util.ReflectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListParallelTimeoutTest
extends ContextTestSupport {
    @Test
    public void testRecipientListParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)mock.message(0).body()).not(RecipientListParallelTimeoutTest.body().contains((Object)"A"));
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "slip", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
        List<Processor> list = this.getProcessors("foo");
        RecipientList rl = (RecipientList)list.get(0);
        Assertions.assertNotNull((Object)rl);
        Object pc = ReflectionHelper.getField((Field)rl.getClass().getDeclaredField("aggregateExecutorService"), (Object)rl);
        Assertions.assertNotNull((Object)pc);
        ExecutorService es = RecipientListParallelTimeoutTest.assertIsInstanceOf(ExecutorService.class, pc);
        Assertions.assertFalse((boolean)es.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)es.isShutdown());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").recipientList((Expression)this.header("slip")).aggregationStrategy(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().timeout(500L).id("foo")).to("mock:result");
                this.from("direct:a").delay(1000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(100L).setBody((Expression)this.constant("C"));
            }
        };
    }
}

