/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListParallelSynchronousTest
extends ContextTestSupport {
    private String before;
    private String middle;
    private String middle2;
    private String after;

    @Test
    public void testSynchronous() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:a", (Object)"A", "whereTo", (Object)"direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotEquals((Object)this.before, (Object)this.middle);
        Assertions.assertNotEquals((Object)this.before, (Object)this.middle2);
        Assertions.assertNotEquals((Object)this.after, (Object)this.middle);
        Assertions.assertNotEquals((Object)this.after, (Object)this.middle2);
        Assertions.assertEquals((Object)this.before, (Object)this.after);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)this.from("direct:a").process(e -> {
                    RecipientListParallelSynchronousTest.this.before = Thread.currentThread().getName();
                })).recipientList((Expression)this.header("whereTo")).parallelProcessing().synchronous().process(e -> {
                    RecipientListParallelSynchronousTest.this.after = Thread.currentThread().getName();
                })).to("mock:end");
                this.from("direct:b").process(e -> {
                    RecipientListParallelSynchronousTest.this.middle = Thread.currentThread().getName();
                });
                this.from("direct:c").process(e -> {
                    RecipientListParallelSynchronousTest.this.middle2 = Thread.currentThread().getName();
                });
            }
        };
    }
}

