/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListParallelStopOnExceptionWithOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testRecipientListStopOnException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMinimumMessageCount(0);
        String out = (String)this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c", String.class);
        Assertions.assertEquals((Object)"Damn Forced", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).to("mock:handled")).transform((Expression)this.simple("Damn ${exception.message}"));
                this.from("direct:start").recipientList((Expression)this.header("foo")).stopOnException().parallelProcessing().to("mock:result");
                this.from("direct:a").to("mock:a");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).throwException((Exception)new IllegalArgumentException("Forced"));
                this.from("direct:c").to("mock:c");
            }
        };
    }
}

