/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListParallelFineGrainedErrorHandlingTest
extends ContextTestSupport {
    private static int counter;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("fail", (Object)new MyFailBean());
        return jndi;
    }

    @Test
    public void testRecipientListOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).redeliveryDelay(0L).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException().parallelProcessing();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,mock:baz");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListError() throws Exception {
        counter = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).redeliveryDelay(0L).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException().parallelProcessing();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMinimumMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,bean:fail,mock:baz");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)counter);
    }

    @Test
    public void testRecipientListAsBeanError() throws Exception {
        counter = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                RecipientListParallelFineGrainedErrorHandlingTest.this.context.setTracing(Boolean.valueOf(true));
                this.onException(Exception.class).redeliveryDelay(0L).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).bean(MyRecipientBean.class);
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMinimumMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            RecipientListParallelFineGrainedErrorHandlingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            RecipientListParallelFineGrainedErrorHandlingTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)counter);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyFailBean {
        public String doSomething(Exchange exchange) {
            ++counter;
            Assertions.assertEquals((Object)"bean://fail", (Object)exchange.getProperty("CamelToEndpoint", String.class));
            throw new IllegalArgumentException("Damn");
        }
    }

    public static class MyRecipientBean {
        @RecipientList(stopOnException=true, parallelProcessing=true)
        public String sendSomewhere(Exchange exchange) {
            return "mock:foo,mock:bar,bean:fail,mock:baz";
        }
    }
}

