/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListParallelAggregateThreadPoolIssueTest
extends ContextTestSupport {
    @Test
    public void testRecipientListParallelALot() throws Exception {
        String before = this.context.getExecutorServiceManager().resolveThreadName("foo");
        for (int i = 0; i < 10; ++i) {
            MockEndpoint mock = this.getMockEndpoint("mock:result");
            mock.reset();
            mock.expectedBodiesReceivedInAnyOrder(new Object[]{"c", "b", "a"});
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
            this.assertMockEndpointsSatisfied();
        }
        String after = this.context.getExecutorServiceManager().resolveThreadName("foo");
        int num1 = (Integer)this.context.getTypeConverter().convertTo(Integer.TYPE, (Object)before);
        int num2 = (Integer)this.context.getTypeConverter().convertTo(Integer.TYPE, (Object)after);
        int diff = num2 - num1;
        Assertions.assertTrue((diff >= 11 ? 1 : 0) != 0, (String)("There should be 12 or more threads in use, was: " + diff));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                RecipientListParallelAggregateThreadPoolIssueTest.this.context.getExecutorServiceManager().setThreadNamePattern("#counter#");
                this.from("direct:start").recipientList((Expression)this.header("foo")).parallelProcessing();
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").to("log:a")).transform((Expression)this.constant("a"))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").to("log:b")).transform((Expression)this.constant("b"))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:c").to("log:c")).transform((Expression)this.constant("c"))).to("mock:result");
            }
        };
    }
}

