/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RecipientListNoErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testRecipientListNoErrorHandler() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:dead").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((RecipientListDefinition)this.from("direct:start").recipientList().constant((Object)"direct:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

