/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.util.ReflectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListNoCacheTest
extends ContextTestSupport {
    @Test
    public void testNoCache() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo");
        this.sendBody("bar");
        List<Processor> list = this.getProcessors("foo");
        RecipientList rl = (RecipientList)list.get(0);
        Assertions.assertNotNull((Object)rl);
        Assertions.assertEquals((int)-1, (int)rl.getCacheSize());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"foo", "bar"});
        y.expectedBodiesReceived(new Object[]{"foo", "bar"});
        z.expectedBodiesReceived(new Object[]{"foo", "bar"});
        this.sendBody("foo");
        this.sendBody("bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
    }

    @Test
    public void testNoThreadPool() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"foo", "bar"});
        y.expectedBodiesReceived(new Object[]{"foo", "bar"});
        z.expectedBodiesReceived(new Object[]{"foo", "bar"});
        this.sendBody("foo");
        this.sendBody("bar");
        this.assertMockEndpointsSatisfied();
        List<Processor> list = this.getProcessors("foo");
        RecipientList rl = (RecipientList)list.get(0);
        Assertions.assertNotNull((Object)rl);
        Assertions.assertEquals((int)-1, (int)rl.getCacheSize());
        Object pc = ReflectionHelper.getField((Field)rl.getClass().getDeclaredField("producerCache"), (Object)rl);
        Assertions.assertNotNull((Object)pc);
        RecipientListNoCacheTest.assertIsInstanceOf(EmptyProducerCache.class, pc);
        pc = ReflectionHelper.getField((Field)rl.getClass().getDeclaredField("aggregateExecutorService"), (Object)rl);
        Assertions.assertNull((Object)pc);
    }

    protected void sendBody(String body) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("recipientListHeader").tokenize(",")).cacheSize(-1).id("foo");
            }
        };
    }
}

