/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListMEPTest
extends ContextTestSupport {
    @Test
    public void testMEPInOnly() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World", "Hello Again"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Again");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMEPInOutOnly() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World", "Hello Again"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World", "Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        out = (String)this.template.requestBody("direct:start", (Object)"Hello Again", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RecipientListDefinition)this.from("direct:start").recipientList().constant((Object)"seda:foo?exchangePattern=InOut")).to("mock:result");
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).transform().constant((Object)"Bye World");
            }
        };
    }
}

