/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class RecipientListLeakTest
extends ContextTestSupport {
    @Test
    public void testRecipientListLeak() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        y.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        z.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.sendBody("Hello World");
        this.sendBody("Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody(String body) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("recipientListHeader"));
            }
        };
    }
}

