/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListIgnoreInvalidEndpointsTest
extends ContextTestSupport {
    @Test
    public void testRecipientListWithIgnoreInvalidEndpointsOption() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint endpointA = this.getMockEndpoint("mock:endpointA");
        endpointA.expectedBodiesReceived(new Object[]{"Hello a"});
        this.template.requestBody("direct:startA", (Object)"Hello World", String.class);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListWithoutIgnoreInvalidEndpointsOption() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        MockEndpoint endpointA = this.getMockEndpoint("mock:endpointA");
        endpointA.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:startB", (Object)"Hello World", String.class);
            Assertions.fail((String)"Expect the exception here.");
        }
        catch (Exception ex) {
            boolean b = ex.getCause() instanceof NoSuchEndpointException;
            Assertions.assertTrue((boolean)b, (String)"Get a wrong cause of the exception");
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:startA").recipientList((Expression)this.simple("mock:result,fail:endpoint,direct:a")).ignoreInvalidEndpoints();
                this.from("direct:startB").recipientList((Expression)this.simple("mock:result,fail:endpoint,direct:a"));
                ((RouteDefinition)this.from("direct:a").transform((Expression)this.constant("Hello a"))).to("mock:endpointA");
            }
        };
    }
}

