/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListExchangePropertyAggregationStrategyTest
extends ContextTestSupport {
    private final MyAggregationStrategy strategy = new MyAggregationStrategy();

    @Test
    public void testRecipientExchangeProperty() throws Exception {
        this.getMockEndpoint("mock:a").expectedPropertyReceived("CamelRecipientListEndpoint", (Object)"direct://a");
        this.getMockEndpoint("mock:a").expectedPropertyReceived("CamelToEndpoint", (Object)"mock://a");
        this.getMockEndpoint("mock:b").expectedPropertyReceived("CamelRecipientListEndpoint", (Object)"direct://b");
        this.getMockEndpoint("mock:b").expectedPropertyReceived("CamelToEndpoint", (Object)"mock://b");
        this.getMockEndpoint("mock:c").expectedPropertyReceived("CamelRecipientListEndpoint", (Object)"direct://c");
        this.getMockEndpoint("mock:c").expectedPropertyReceived("CamelToEndpoint", (Object)"mock://c");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello c"});
        mock.expectedPropertyReceived("CamelRecipientListEndpoint", (Object)"direct://c");
        String out = (String)this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "slip", (Object)"direct:a,direct:b,direct:c", String.class);
        Assertions.assertEquals((Object)"Hello c", (Object)out);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.strategy.getUris().size());
        Assertions.assertEquals((Object)"direct://a", (Object)this.strategy.getUris().get(0));
        Assertions.assertEquals((Object)"direct://b", (Object)this.strategy.getUris().get(1));
        Assertions.assertEquals((Object)"direct://c", (Object)this.strategy.getUris().get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.header("slip")).aggregationStrategy((AggregationStrategy)RecipientListExchangePropertyAggregationStrategyTest.this.strategy).to("mock:result");
                ((RouteDefinition)this.from("direct:a").to("mock:a")).transform((Expression)this.constant("Hello a"));
                ((RouteDefinition)this.from("direct:b").to("mock:b")).transform((Expression)this.constant("Hello b"));
                ((RouteDefinition)this.from("direct:c").to("mock:c")).transform((Expression)this.constant("Hello c"));
            }
        };
    }

    private static class MyAggregationStrategy
    implements AggregationStrategy {
        private final List<String> uris = new ArrayList<String>();

        private MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            this.uris.add((String)newExchange.getProperty("CamelRecipientListEndpoint", String.class));
            return newExchange;
        }

        public List<String> getUris() {
            return this.uris;
        }
    }
}

