/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListBeanTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    @Test
    public void testRecipientListWithBean() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello c"});
        String out = (String)this.template.requestBody("direct:start", (Object)"direct:a,direct:b,direct:c", String.class);
        Assertions.assertEquals((Object)"Hello c", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecipientListWithParams() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello b"});
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("one", 21);
        headers.put("two", "direct:a,direct:b,direct:c");
        String out = (String)this.template.requestBodyAndHeaders("direct:params", (Object)"Hello World", headers, String.class);
        Assertions.assertEquals((Object)"Hello b", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.method("myBean", "foo")).to("mock:result");
                this.from("direct:params").recipientList((Expression)this.method("myBean", "bar(${header.one}, ${header.two})"), ",").to("mock:result");
                this.from("direct:a").transform((Expression)this.constant("Hello a"));
                this.from("direct:b").transform((Expression)this.constant("Hello b"));
                this.from("direct:c").transform((Expression)this.constant("Hello c"));
            }
        };
    }

    public static class MyBean {
        public String[] foo(String body) {
            return body.split(",");
        }

        public String bar(int one, String two) {
            Assertions.assertEquals((int)21, (int)one);
            Assertions.assertEquals((Object)"direct:a,direct:b,direct:c", (Object)two);
            return "direct:c,direct:b";
        }
    }
}

