/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Animal;
import org.apache.camel.processor.AnimalDeepClonePrepare;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListBeanOnPrepareTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myPrepare", (Object)new AnimalDeepClonePrepare());
        return jndi;
    }

    @Test
    public void testRecipientListBeanOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:b").message(0).body(String.class)).isEqualTo((Object)"1 Tiger");
        this.template.sendBodyAndHeader("direct:start", (Object)new Animal(1, "Tiger"), "foo", (Object)"direct:a,direct:b");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").bean(RecipientListBeanOnPrepareTest.class, "doSomething");
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Animal body = (Animal)exchange.getIn().getBody(Animal.class);
                        Assertions.assertEquals((int)1, (int)body.getId());
                        Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
                        body.setName("Tony the Tiger");
                    }
                })).to("mock:a");
                ((RouteDefinition)this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Animal body = (Animal)exchange.getIn().getBody(Animal.class);
                        Assertions.assertEquals((int)1, (int)body.getId());
                        Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
                    }
                })).to("mock:b");
            }
        };
    }

    @RecipientList(onPrepare="myPrepare")
    public static String doSomething() {
        return "direct:a,direct:b";
    }
}

