/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProcessorMutateExchangeRedeliverTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testRedeliverA() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:a", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    @Test
    public void testRedeliverB() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:b", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        Assertions.assertFalse((boolean)exchange.hasOut(), (String)"Should not have OUT");
                        Assertions.assertNull((Object)exchange.getException());
                        exchange.getIn().setBody((Object)"Bye World");
                        ++counter;
                        throw new IllegalArgumentException("Forced");
                    }
                });
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        Assertions.assertFalse((boolean)exchange.hasOut(), (String)"Should not have OUT");
                        Assertions.assertNull((Object)exchange.getException());
                        exchange.getMessage().setBody((Object)"Bye World");
                        ++counter;
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

