/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.impl.engine.PooledProcessorExchangeFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PooledExchangeTest
extends ContextTestSupport {
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicReference<Exchange> ref = new AtomicReference();

    PooledExchangeTest() {
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        ecc.setExchangeFactory((ExchangeFactory)new PooledExchangeFactory());
        ecc.setProcessorExchangeFactory((ProcessorExchangeFactory)new PooledProcessorExchangeFactory());
        ecc.getExchangeFactory().setStatisticsEnabled(true);
        ecc.getProcessorExchangeFactory().setStatisticsEnabled(true);
        return camelContext;
    }

    @Test
    void testSameExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedPropertyValuesReceivedInAnyOrder("myprop", new Object[]{1, 3, 5});
        mock.expectedHeaderValuesReceivedInAnyOrder("myheader", new Object[]{2, 4, 6});
        ((MockValueBuilder)mock.message(0).header("first")).isEqualTo((Object)true);
        ((MockValueBuilder)mock.message(1).header("first")).isNull();
        ((MockValueBuilder)mock.message(2).header("first")).isNull();
        this.context.getRouteController().startAllRoutes();
        mock.setResultWaitTime(TimeUnit.MINUTES.toMillis(1L));
        mock.assertIsSatisfied();
        PooledObjectFactory.Statistics stat = this.context.getCamelContextExtension().getExchangeFactoryManager().getStatistics();
        Assertions.assertEquals((long)1L, (long)stat.getCreatedCounter());
        Assertions.assertEquals((long)2L, (long)stat.getAcquiredCounter());
        Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> Assertions.assertEquals((long)3L, (long)stat.getReleasedCounter()));
        Assertions.assertEquals((long)0L, (long)stat.getDiscardedCounter());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:foo?period=1&delay=1&repeatCount=3").autoStartup(false).setProperty("myprop", PooledExchangeTest.this.counter::incrementAndGet)).setHeader("myheader", PooledExchangeTest.this.counter::incrementAndGet)).process(new Processor(){

                    public void process(Exchange exchange) {
                        Exchange old = PooledExchangeTest.this.ref.get();
                        if (old == null) {
                            PooledExchangeTest.this.ref.set(exchange);
                            exchange.getMessage().setHeader("first", (Object)true);
                        } else {
                            Assertions.assertSame((Object)old, (Object)exchange);
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

