/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.PollEnrichDefinition;
import org.junit.jupiter.api.Test;

public class PollEnrichVariableHeadersTest
extends ContextTestSupport {
    @Test
    public void testReceive() throws Exception {
        this.template.sendBodyAndHeader("seda:foo", (Object)"Bye World", "echo", (Object)"CamelCamel");
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:after").expectedVariableReceived("bye", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedVariableReceived("bye", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedVariableReceived("header:bye.echo", (Object)"CamelCamel");
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).header("echo")).isNull();
        this.template.sendBody("direct:receive", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((PollEnrichDefinition)this.from("direct:receive").pollEnrich().constant((Object)"seda:foo")).timeout(1000L).variableReceive("bye").to("mock:after")).setBody((Expression)this.simple("${variable:bye}"))).to("mock:result");
            }
        };
    }
}

