/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.PollEnrichDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnrichVariableErrorTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testThrowException() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PollEnrichDefinition)this.from("direct:receive").pollEnrich().constant((Object)"seda:foo")).timeout(1000L).variableReceive("bye").to("mock:result");
            }
        });
        this.context.start();
        this.template.send("seda:foo", e -> {
            e.getMessage().setBody((Object)"Bye World");
            e.setException((Throwable)new IllegalArgumentException());
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> e.getMessage().setBody((Object)"World"));
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PollEnrichDefinition)this.from("direct:receive").pollEnrich().constant((Object)"seda:foo")).timeout(1000L).variableReceive("bye").to("mock:result");
            }
        });
        this.context.start();
        SedaEndpoint se = (SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class);
        Exchange ex = se.createExchange();
        ex.getMessage().setBody((Object)"Bye World");
        ex.setRouteStop(true);
        se.getQueue().add(ex);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> e.getMessage().setBody((Object)"World"));
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertTrue((boolean)out.isRouteStop());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRollbackOnly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PollEnrichDefinition)this.from("direct:receive").pollEnrich().constant((Object)"seda:foo")).timeout(1000L).variableReceive("bye").to("mock:result");
            }
        });
        this.context.start();
        SedaEndpoint se = (SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class);
        Exchange ex = se.createExchange();
        ex.getMessage().setBody((Object)"Bye World");
        ex.setRollbackOnly(true);
        se.getQueue().add(ex);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:receive", e -> e.getMessage().setBody((Object)"World"));
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasVariables());
        Assertions.assertTrue((boolean)out.isRollbackOnly());
        Assertions.assertEquals((Object)"Bye World", (Object)out.getMessage().getBody());
        this.assertMockEndpointsSatisfied();
    }
}

