/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.processor.PollEnricher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PollEnrichNoCacheTest
extends ContextTestSupport {
    @Test
    public void testNoCache() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "seda:x");
        this.sendBody("foo", "seda:y");
        this.sendBody("foo", "seda:z");
        this.sendBody("bar", "seda:x");
        this.sendBody("bar", "seda:y");
        this.sendBody("bar", "seda:z");
        List<Processor> list = this.getProcessors("foo");
        PollEnricher ep = (PollEnricher)list.get(0);
        Assertions.assertNotNull((Object)ep);
        Assertions.assertEquals((int)-1, (int)ep.getCacheSize());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.template.sendBody("seda:x", (Object)"x");
        this.template.sendBody("seda:y", (Object)"y");
        this.template.sendBody("seda:z", (Object)"z");
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "seda:x");
        this.sendBody("foo", "seda:y");
        this.sendBody("foo", "seda:z");
        this.sendBody("bar", "seda:x");
        this.sendBody("bar", "seda:y");
        this.sendBody("bar", "seda:z");
        this.sendBody("dummy", "seda:dummy");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
    }

    protected void sendBody(String body, String uri) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "myHeader", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PollEnrichDefinition)this.from("direct:a").pollEnrich().header("myHeader")).timeout(0L).cacheSize(-1).end().id("foo");
            }
        };
    }
}

