/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PolicyPerProcessorTest
extends ContextTestSupport {
    @Test
    public void testPolicy() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("foo", (Object)"police finished execution");
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("bar", (Object)"was wrapped");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"police finished execution");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("bar", (Object)"police finished execution");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        MyPolicy bar = (MyPolicy)this.context.getRegistry().lookupByNameAndType("bar", MyPolicy.class);
        Assertions.assertEquals((int)1, (int)foo.getInvoked(), (String)"Should only be invoked 1 time");
        Assertions.assertEquals((int)1, (int)bar.getInvoked(), (String)"Should only be invoked 1 time");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        jndi.bind("bar", (Object)new MyPolicy("bar"));
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy("foo").to("mock:foo")).end().policy("bar").to("mock:bar")).end().to("mock:result");
            }
        };
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, final Processor processor) {
            return new Processor(){

                public void process(Exchange exchange) throws Exception {
                    ++invoked;
                    exchange.getIn().setHeader(name, (Object)"was wrapped");
                    processor.process(exchange);
                    exchange.getIn().setHeader(name, (Object)"police finished execution");
                }
            };
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

