/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PipelineTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    @Test
    public void testSendMessageThroughAPipeline() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{4});
        Exchange results = this.template.request("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)1);
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
        Assertions.assertEquals((Object)4, (Object)results.getMessage().getBody(), (String)"Result body");
    }

    @Test
    public void testResultsReturned() {
        Exchange exchange = this.template.request("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getMessage().getBody());
        Assertions.assertEquals((Object)3, (Object)exchange.getMessage().getHeader("copy-counter"));
    }

    @Test
    public void testOnlyProperties() {
        Exchange exchange = this.template.request("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("header", (Object)"headerValue");
            }
        });
        Assertions.assertEquals((Object)"headerValue", (Object)exchange.getMessage().getHeader("header"));
        Assertions.assertEquals((Object)3, (Object)exchange.getMessage().getHeader("copy-counter"));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                Integer number = (Integer)exchange.getIn().getBody(Integer.class);
                if (number == null) {
                    number = 0;
                }
                number = number + 1;
                exchange.getMessage().setBody((Object)number);
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").pipeline(new String[]{"direct:x", "direct:y", "direct:z", "mock:result"});
                this.from("direct:x").process(processor);
                this.from("direct:y").process(processor);
                this.from("direct:z").process(processor);
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").process((Processor)new InToOut())).process((Processor)new InToOut())).process((Processor)new InToOut());
            }
        };
    }

    private static final class InToOut
    implements Processor {
        private InToOut() {
        }

        public void process(Exchange exchange) {
            exchange.getMessage().copyFrom(exchange.getIn());
            Integer counter = (Integer)exchange.getIn().getHeader("copy-counter", Integer.class);
            if (counter == null) {
                counter = 0;
            }
            exchange.getMessage().setHeader("copy-counter", (Object)(counter + 1));
        }
    }
}

