/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.event.AbstractExchangeEvent;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PipelineStepWithEventTest
extends ContextTestSupport {
    private final MyStepEventListener listener = new MyStepEventListener();

    @Test
    public void testPipelineStep() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:a2").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:b2").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.listener.getEvents().size());
        BeforeStepEvent event = (BeforeStepEvent)((Object)this.listener.getEvents().get(0));
        Assertions.assertEquals((Object)"step-a", (Object)event.getId());
        AfterStepEvent event2 = (AfterStepEvent)((Object)this.listener.getEvents().get(1));
        Assertions.assertEquals((Object)"step-a", (Object)event2.getId());
        Assertions.assertTrue((event2.getTimeTaken() > 0L ? 1 : 0) != 0, (String)"Should take a little time");
        BeforeStepEvent event3 = (BeforeStepEvent)((Object)this.listener.getEvents().get(2));
        Assertions.assertEquals((Object)"step-b", (Object)event3.getId());
        AfterStepEvent event4 = (AfterStepEvent)((Object)this.listener.getEvents().get(3));
        Assertions.assertEquals((Object)"step-b", (Object)event4.getId());
        Assertions.assertTrue((event4.getTimeTaken() > 0L ? 1 : 0) != 0, (String)"Should take a little time");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("direct:start").pipeline().id("step-a")).to("mock:a")).delay((Expression)this.constant(10)).end().to("mock:a2").end().pipeline().id("step-b")).to("mock:b")).delay((Expression)this.constant(20)).end().to("mock:b2").end().to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new MyInterceptStrategy());
        context.addService((Object)this.listener);
        return context;
    }

    private static class MyStepEventListener
    extends ServiceSupport
    implements StepEventListener {
        private final List<EventObject> events = new ArrayList<EventObject>();

        private MyStepEventListener() {
        }

        @Override
        public void beforeStep(BeforeStepEvent event) {
            this.events.add((EventObject)((Object)event));
        }

        @Override
        public void afterStep(AfterStepEvent event) {
            this.events.add((EventObject)((Object)event));
        }

        public List<EventObject> getEvents() {
            return this.events;
        }
    }

    private static class BeforeStepEvent
    extends AbstractExchangeEvent {
        private final String id;

        public BeforeStepEvent(Exchange source, String id) {
            super(source);
            this.id = id;
        }

        public CamelEvent.Type getType() {
            return CamelEvent.Type.Custom;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class AfterStepEvent
    extends AbstractExchangeEvent {
        private final String id;
        private final long timeTaken;

        public AfterStepEvent(Exchange source, String id, long timeTaken) {
            super(source);
            this.id = id;
            this.timeTaken = timeTaken;
        }

        public CamelEvent.Type getType() {
            return CamelEvent.Type.Custom;
        }

        public String getId() {
            return this.id;
        }

        public long getTimeTaken() {
            return this.timeTaken;
        }
    }

    private static class MyInterceptStrategy
    implements InterceptStrategy {
        private MyInterceptStrategy() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) {
            StepEventListener listener = (StepEventListener)context.hasService(StepEventListener.class);
            if (definition instanceof PipelineDefinition) {
                return new MyStepEventProcessor(definition.getId(), target, listener);
            }
            return target;
        }
    }

    private static class MyStepEventProcessor
    extends DelegateAsyncProcessor {
        private final StepEventListener listener;
        private final String id;

        public MyStepEventProcessor(String id, Processor processor, StepEventListener listener) {
            super(processor);
            this.id = id;
            this.listener = listener;
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            StopWatch watch = new StopWatch();
            if (this.listener != null) {
                this.listener.beforeStep(new BeforeStepEvent(exchange, this.id));
            }
            return super.process(exchange, doneSync -> {
                if (this.listener != null) {
                    this.listener.afterStep(new AfterStepEvent(exchange, this.id, watch.taken()));
                }
                callback.done(doneSync);
            });
        }
    }

    private static interface StepEventListener {
        public void beforeStep(BeforeStepEvent var1);

        public void afterStep(AfterStepEvent var1);
    }
}

