/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionRedeliveryPlaceholderTest
extends ContextTestSupport {
    private static String counter = "";

    @Test
    public void testRedeliveryPlaceholder() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"123", (Object)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                OnExceptionRedeliveryPlaceholderTest.this.context.getPropertiesComponent().addInitialProperty("myCount", "3");
                OnExceptionRedeliveryPlaceholderTest.this.context.getPropertiesComponent().addInitialProperty("myFac", "1");
                ((OnExceptionDefinition)this.from("direct:start").onException(Exception.class).maximumRedeliveryDelay(1L).maximumRedeliveries("{{myCount}}").collisionAvoidanceFactor("{{myFac}}").onRedelivery(e -> {
                    counter = counter + String.valueOf(e.getMessage().getHeader("CamelRedeliveryCounter"));
                }).handled(true).to("mock:error")).end().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

