/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.junit.jupiter.api.Test;

public class OnCompletionWhenTest
extends ContextTestSupport {
    @Test
    public void testSynchronizeCompleteWhen() throws Exception {
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSynchronizeCompleteNoWhen() throws Exception {
        this.getMockEndpoint("mock:sync").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)((OnCompletionDefinition)this.from("direct:start").onCompletion().onWhen(this.body().contains((Object)"Hello")).to("log:sync")).to("mock:sync")).end().to("log:original").to("mock:result");
            }
        };
    }
}

