/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionUseOriginalBodyTest
extends ContextTestSupport {
    @Test
    public void testOnCompletionUseOriginalBody() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:before").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"OnComplete:Hello World"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.onCompletion().useOriginalBody().parallelProcessing().to("mock:before")).delay(1000L).setBody((Expression)this.simple("OnComplete:${body}"))).to("mock:after");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            if (((String)exchange.getIn().getBody(String.class)).contains("Kaboom")) {
                throw new IllegalArgumentException("Kaboom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

