/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionShutdownProcessorTest
extends ContextTestSupport {
    private final MyProcessor processor = new MyProcessor();

    @Test
    public void testSynchronizeComplete() throws Exception {
        Assertions.assertEquals((Object)"Started", (Object)this.processor.getStatus().name());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertEquals((Object)"Stopped", (Object)this.processor.getStatus().name());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onCompletion().process((Processor)OnCompletionShutdownProcessorTest.this.processor);
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class MyProcessor
    extends ServiceSupport
    implements Processor {
        public void process(Exchange exchange) {
            exchange.getIn().setBody((Object)"Bye World");
        }

        protected void doStart() {
        }

        protected void doStop() {
        }
    }
}

