/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionModeBeforeConsumerExceptionSuppressedTest
extends ContextTestSupport {
    @Test
    public void testOnCompletionModeBeforeConsumerExceptionSuppressed() {
        Exchange out = this.template.request("direct:foo", exchange -> exchange.getIn().setBody((Object)"Camel"));
        Exception fooException = out.getException();
        OnCompletionModeBeforeConsumerExceptionSuppressedTest.assertIsInstanceOf(FooException.class, fooException);
        Throwable[] suppressed = fooException.getSuppressed();
        Assertions.assertEquals((int)1, (int)suppressed.length);
        OnCompletionModeBeforeConsumerExceptionSuppressedTest.assertIsInstanceOf(SuppressedException.class, suppressed[0]);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)((RouteDefinition)this.from("direct:foo").process(exchange -> {
                    throw new FooException();
                })).onCompletion().modeBeforeConsumer().process(exchange -> {
                    throw new SuppressedException();
                })).end();
            }
        };
    }

    public static class FooException
    extends RuntimeException {
    }

    public static class SuppressedException
    extends RuntimeException {
    }
}

