/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.processor.OnCompletionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionFailAndOkTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:ok").expectedMessageCount(1);
        this.getMockEndpoint("mock:fail").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFail() throws Exception {
        this.getMockEndpoint("mock:ok").expectedMessageCount(0);
        this.getMockEndpoint("mock:fail").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOkAndFail() throws Exception {
        this.getMockEndpoint("mock:ok").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:fail").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)((OnCompletionDefinition)((OnCompletionDefinition)((OnCompletionDefinition)this.from("direct:start").onCompletion().onCompleteOnly().to("log:ok")).to("mock:ok")).end().onCompletion().onFailureOnly().to("log:fail")).to("mock:fail")).end().process((Processor)new OnCompletionTest.MyProcessor()).to("mock:result");
            }
        };
    }
}

